/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.driver.common;

import java.util.Properties;
import oracle.install.commons.base.driver.common.SetupDriverEvent;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupDriverListener;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.DefaultTextualProgressUI;
import oracle.install.commons.util.progress.ProgressUI;

public abstract class SetupDriver<T> {
    protected T setupBean;
    protected Properties commandLineArgs;
    protected Properties properties;
    protected ProgressUI progressUI;
    private EventSupport<SetupDriverEvent> eventSupport = new EventSupport();
    private SetupMode setupMode;
    private static SetupDriver driver = null;

    protected SetupDriver() {
        this.properties = new Properties();
        this.progressUI = new DefaultTextualProgressUI();
        this.setupMode = SetupMode.SILENT;
    }

    public static void registerDriver(String driverClassName) {
        System.setProperty(SetupDriver.class.getName(), driverClassName);
    }

    public static <A extends SetupDriver> A getInstance() {
        if (driver == null) {
            try {
                String driveClassName = System.getProperty(SetupDriver.class.getName());
                if (driveClassName != null) {
                    try {
                        Class<?> clazz = Class.forName(driveClassName);
                        driver = (SetupDriver)clazz.newInstance();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (A)driver;
    }

    public static <A extends SetupDriver> A getInstance(Class<A> type) {
        if (driver == null) {
            try {
                driver = (SetupDriver)type.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (A)driver;
    }

    public ProgressUI getProgressUI() {
        return this.progressUI;
    }

    public void setProgressUI(ProgressUI progressUI) {
        if (this.progressUI != progressUI) {
            this.progressUI = progressUI;
            this.setupMode = progressUI != null ? SetupMode.INTERACTIVE : SetupMode.SILENT;
        }
    }

    public SetupMode getSetupMode() {
        return this.setupMode;
    }

    public T getSetupBean() {
        return this.setupBean;
    }

    public void setSetupBean(T setupBean) {
        this.setupBean = setupBean;
    }

    public void showUsage() {
    }

    public void processCommandLine(String ... args) throws IllegalArgumentException {
    }

    public void pause() throws IllegalStateException {
    }

    public void resume() throws IllegalStateException {
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Properties getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public void addSetupDriverListener(SetupDriverListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeSetupDriverListener(SetupDriverListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    protected void fireSetupDriverEvent(SetupDriverEvent setupDriverEvent) {
        this.eventSupport.fireEvent(setupDriverEvent);
    }

    protected abstract CompositeJob prepareJob() throws SetupDriverException;

    public abstract void load() throws SetupDriverException;

    public abstract void unload() throws SetupDriverException;

    public abstract void setup() throws SetupDriverException;
}

